# Guía de Tipografía - Carolina Silva Studio

## Fuentes Implementadas

### 1. **Lato** (Sans-serif - Fuente Principal)
- **Uso:** Texto general, navegación, párrafos, botones
- **Peso:** 300 (Light), 400 (Regular), 700 (Bold)
- **Características:** Limpia, moderna, profesional, excelente legibilidad

**Aplicada en:**
- Body text (todo el sitio)
- Navegación
- Subtítulos y descripciones
- Texto de botones
- Footer

### 2. **Cormorant** (Serif - Títulos)
- **Uso:** Títulos principales y secundarios
- **Peso:** 300-600 (variable)
- **Características:** Elegante, editorial, sofisticada, con personalidad fashion

**Aplicada en:**
- H1 (Título hero principal)
- H2 (Todos los títulos de sección)
- H3 (Títulos de servicios y portafolio)
- Títulos de sección destacados

### 3. **Tuesday Night** (Script/Cursiva)
- **Uso:** Detalles especiales, logo, frases destacadas
- **Características:** Personal, artística, manuscrita, distintiva

**Aplicada en:**
- Logo "Carolina Silva" en la navegación
- Frase destacada: "Creo en la belleza como un lenguaje..."
- Elementos de énfasis especiales

## Jerarquía Tipográfica

```
NIVEL 1 (Hero)
Font: Cormorant
Size: 2.5rem - 4.5rem (responsive)
Weight: 400
Usage: Título principal de la página

NIVEL 2 (Secciones)
Font: Cormorant
Size: 2rem - 3rem (responsive)
Weight: 400
Usage: Títulos de cada sección

NIVEL 3 (Subsecciones)
Font: Cormorant
Size: 1.4rem - 1.5rem
Weight: 500
Usage: Títulos de tarjetas y elementos

NIVEL 4 (Texto)
Font: Lato
Size: 0.9rem - 1.1rem
Weight: 300-400
Usage: Cuerpo de texto

NIVEL 5 (Detalles)
Font: Tuesday Night
Size: 1.5rem - 1.6rem
Usage: Logo y frases especiales
```

## Combinación y Contraste

La combinación de estas tres fuentes crea:

✨ **Elegancia** → Cormorant (serif editorial)
🎯 **Claridad** → Lato (sans-serif moderna)
💫 **Personalidad** → Tuesday Night (script artística)

## Recomendaciones de Uso

### ✅ Usar Tuesday Night para:
- Logo
- Frases inspiracionales cortas
- Destacados emocionales
- Máximo 1-2 líneas de texto

### ✅ Usar Cormorant para:
- Todos los títulos (H1, H2, H3)
- Encabezados de sección
- Nombres de servicios
- Títulos de proyectos

### ✅ Usar Lato para:
- Todo el resto del texto
- Navegación
- Botones
- Descripciones
- Footer
- Formularios

## Optimización

Las fuentes están cargadas desde:
- **Google Fonts** (Lato, Cormorant) → CDN rápido y confiable
- **CDN Fonts** (Tuesday Night) → Fuente custom

Con `font-display: swap` para mejor rendimiento y evitar FOIT (Flash of Invisible Text).

---

**Resultado:** Un sitio con tipografía profesional, elegante y con personalidad única que refleja perfectamente la identidad de Carolina Silva Studio.
