# Guía de Integración de Video en Hero Banner

## Video Implementado

He integrado un video de fondo en el hero banner similar al estilo del sitio de referencia (sylviaspitzbart.at).

### Características del Video:

1. **Video de Fondo con Overlay Elegante**
   - Video en loop continuo
   - Overlay semitransparente con degradado dorado
   - Efectos de patrón flotante
   - Animación suave de entrada

2. **Controles de Video**
   - Botón Play/Pause
   - Botón Mute/Unmute
   - Diseño minimalista y elegante
   - Ubicados en la esquina inferior derecha

3. **Optimización**
   - Carga lazy del video
   - Pausa automática cuando no está visible
   - Responsive para móviles
   - Fallback en caso de error

## Cómo Agregar Tu Propio Video

### Opción 1: Video Local
```html
<video class="hero-video" id="heroVideo" autoplay muted loop playsinline>
    <source src="./videos/hero-video.mp4" type="video/mp4">
</video>
```

### Opción 2: Video desde URL
```html
<video class="hero-video" id="heroVideo" autoplay muted loop playsinline>
    <source src="https://tu-servidor.com/video.mp4" type="video/mp4">
</video>
```

### Opción 3: Vimeo o YouTube (alternativa)
Para usar Vimeo:
```html
<iframe 
    src="https://player.vimeo.com/video/TU_VIDEO_ID?background=1&autoplay=1&loop=1&byline=0&title=0"
    frameborder="0" 
    allow="autoplay; fullscreen" 
    class="hero-video">
</iframe>
```

## Recomendaciones para el Video

### Características Técnicas:
- **Resolución**: 1920x1080 (Full HD) mínimo
- **Duración**: 10-30 segundos (loop perfecto)
- **Formato**: MP4 (H.264)
- **Peso**: Máximo 5-10 MB (comprimido)
- **FPS**: 24-30 fps

### Contenido Sugerido:
- Proceso de maquillaje en cámara lenta
- Detalles de productos y herramientas
- Texturas (brochas, paletas, aplicación)
- Ambiente del estudio
- Resultado final de un trabajo

### Herramientas de Compresión:
- HandBrake (gratuito)
- Adobe Media Encoder
- CloudConvert (online)

## Alternativa: Imagen Elegante

Si prefieres no usar video, el diseño también funciona perfectamente con una imagen de alta calidad:

```css
.hero {
    background-image: url('tu-imagen.jpg');
    background-size: cover;
    background-position: center;
}
```

## Video Placeholder Actual

Actualmente usa un video de demostración de Mixkit (gratuito). 
Para reemplazarlo, simplemente cambia la URL en el código:

```html
<!-- Línea actual -->
<source src="https://assets.mixkit.co/videos/preview/mixkit-woman-getting-her-makeup-done-by-a-professional-makeup-artist-40812-large.mp4" type="video/mp4">

<!-- Reemplazar con tu video -->
<source src="TU_VIDEO_AQUI.mp4" type="video/mp4">
```

## Efecto Visual

El overlay tiene:
- 85% de opacidad con color crema
- Degradado radial dorado
- Patrón flotante animado
- Asegura legibilidad del texto sobre el video

¡El resultado es un hero banner moderno, elegante y profesional!
